#pragma once

#include "common.h"
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/libs/geolib/include/bounding_box.h>
#include <yandex/maps/wiki/common/geom.h>

#include <vector>

namespace maps::wiki::merge_poi {
class IndoorLevel
{
public:
    geolib3::BoundingBox boundingBox() const;
    bool contains(const poi_feed::FeedObjectData::Position&) const;

    ObjectId oid = 0;
    maps::wiki::common::Geom polygon;

};

struct IndoorPlansData
{
    std::set<ObjectId> inactivePlans;
    std::vector<IndoorLevel> activeLevels;
};
IndoorPlansData loadIndoorPlansData(pgpool3::Pool& pool);

} // namespace maps::wiki::poi
