#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/libs/editor_client/include/instance.h>
#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <yandex/maps/wiki/common/name_type.h>

#include <unordered_set>
#include <string>
#include <vector>

namespace maps::wiki::merge_poi {

enum class IsLocal
{
    Yes,
    No
};

using Lang = std::string;
using NameType = common::NameType;

struct Name
{
    NameType nameType;
    std::optional<IsLocal> isLocal;
    Lang lang;
    std::string text;
};

class Names
{
public:
    explicit Names(const poi_feed::FeedObjectData& poi);
    explicit Names(
        const editor_client::BasicEditorObject& poi,
        const EditorCfg& editorCfg);
    explicit Names(std::vector<Name> names);

    void writeTo(
        editor_client::BasicEditorObject& poi, const EditorCfg& editorCfg) const;
    bool empty() const { return names_.empty(); }
    size_t size() const { return names_.size(); }
    std::unordered_set<Lang> localLangs() const;
    std::unordered_set<Lang> langs() const;

    enum class UpdateResult
    {
        LangLost,
        RubricName,
        Updated
    };
    std::set<UpdateResult> update(const Names& patchNames, const EditorCfg& editorCfg);
    Names fixContradictingNamesLangs(const Names& patchNames) const;

private:
    std::vector<Name> names_;
};

bool isRubricName(const common::LocalizedString&, const EditorCfg& editorCfg);
std::string guessNameAttr(
    const editor_client::BasicEditorObject& poi,
    const EditorCfg& editorCfg);

} // namespace maps::wiki::merge_poi
