#pragma once

#include "common.h"

namespace maps::wiki::merge_poi {

class FeedSettingsConfig;
class NmapsExportResult;
class Config;

struct NamesStat
{
    std::string toReportJson() const;
    bool post(const Config& cfg) const;

    size_t totalEqual = 0;
    size_t totalDifferences = 0;
    size_t withRubricNames = 0;
    size_t withSomeShortInFull = 0;
    size_t altayLangsLess = 0;
    size_t altayLangsGreater = 0;
    size_t sameCountLangsAndNames = 0;
    size_t oneNameEachSet = 0;
};

NamesStat buildNamesStat(
    const poi_feed::FeedObjectDataVector& patches,
    const NmapsExportResult& nmapsData,
    const EditorCfg& editorCfg);

} // namespace maps::wiki::merge_poi
