#include "nmaps_export_result.h"

#include "config.h"
#include "helpers.h"

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::merge_poi {

NmapsExportResult::NmapsExportResult(const Config& cfg)
{
    auto socialTxn = cfg.socialPool().slaveTransaction();
    auto rows = socialTxn->exec("SELECT data_json FROM " + EXPORT_POI_WORKER_FEED_DATA);
    poi_feed::FeedObjectDataVector exportData;
    data_.reserve(rows.size());
    for (const auto& row : rows) {
        poi_feed::FeedObjectData rowData(row[0].as<std::string>());
        if (!rowData.position()) {
            WARN() << "Recent export object " << rowData.nmapsId() << " missing position.";
            continue;
        }
        if (rowData.permalink()) {
            permalinkIdIndex_.emplace(rowData.permalink(), data_.size());
        }
        data_.emplace_back(std::move(rowData));
    }

    index_ = createIndex(data_);

    for (const auto& exportFeedObject : data_) {
        geomIndex_.insert(&*exportFeedObject.position(), exportFeedObject.nmapsId());
    }
    INFO() << "Index exported data by geom.";
    geomIndex_.build();
}

const poi_feed::FeedObjectData*
NmapsExportResult::objectData(poi_feed::ObjectId id) const
{
    auto it = index_.find(id);
    return
        it == index_.end()
        ? nullptr
        : &data_[it->second];
}

std::vector<const poi_feed::FeedObjectData*>
NmapsExportResult::findByPermalink(poi_feed::PermalinkId permalinkId) const
{
    std::vector<const poi_feed::FeedObjectData*> poisData;
    const auto range = permalinkIdIndex_.equal_range(permalinkId);
    for (auto it = range.first; it != range.second; ++it) {
        poisData.push_back(&data_[it->second]);
    }
    return poisData;
}

} // namespace maps::wiki::merge_poi
