#pragma once

#include "common.h"

namespace maps::wiki::merge_poi {

class Config;

class NmapsExportResult
{
public:
    explicit NmapsExportResult(const Config& cfg);

    const poi_feed::FeedObjectData* objectData(poi_feed::ObjectId id) const;
    std::vector<const poi_feed::FeedObjectData*> findByPermalink(poi_feed::PermalinkId permalinkId) const;

    bool empty() const { return data_.empty(); }
    size_t size() const { return data_.size(); }
    const PositionIndex& geomIndex() const { return geomIndex_; }
    poi_feed::FeedObjectDataVector::const_iterator begin() const { return data_.begin(); }
    poi_feed::FeedObjectDataVector::const_iterator end() const { return data_.end(); }

private:
    poi_feed::FeedObjectDataVector data_;
    IdsIndex index_;
    std::unordered_multimap<poi_feed::PermalinkId, size_t> permalinkIdIndex_;
    PositionIndex geomIndex_;
};

} // namespace maps::wiki::merge_poi
