#pragma once
#include "common.h"
#include <maps/wikimap/mapspro/libs/editor_client/include/instance.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>
#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <chrono>
#include <set>
#include <string>

namespace maps::wiki::merge_poi {

std::optional<DispClass> dispClass(const editor_client::BasicEditorObject& object);
std::optional<poi_feed::PermalinkId> permalink(const editor_client::BasicEditorObject& object);
void setPermalink(editor_client::BasicEditorObject& object, poi_feed::PermalinkId permalink);
bool hasVerifiedCoordinates(const editor_client::BasicEditorObject& object);
bool isProtected(const editor_client::BasicEditorObject& object);
bool isRecentCommitByRobot(const editor_client::BasicEditorObject& object);
std::optional<size_t> recentCommitAgeDays(const editor_client::BasicEditorObject& object);
std::optional<poi_feed::RubricId> rubricId(const editor_client::BasicEditorObject& object);
bool hasIsGeoproductAttr(const editor_client::BasicEditorObject& object);
bool isGeoproduct(const editor_client::BasicEditorObject& object);
void setIsGeoproduct(
    editor_client::BasicEditorObject& object,
    const poi_feed::FeedObjectData::IsGeoproduct newGeoproductValue);


enum class AddrCollision
{
    True,
    False,
    NoData
};

enum class BldChange
{
    True,
    False,
    NoData
};

enum class EntranceCollision
{
    True,
    False,
    NoData
};

enum class SameBuilding
{
    True,
    False,
    NoData
};

enum class PoiConflict
{
    High,
    Low,
    NoData
};


struct RelocationResult
{
    AddrCollision addrCollision = AddrCollision::NoData;
    BldChange bldChange = BldChange::NoData;
    SameBuilding sameBuilding = SameBuilding::NoData;
    EntranceCollision entranceCollision = EntranceCollision::NoData;
    PoiConflict poiConflict = PoiConflict::NoData;
};

bool isSameBuildingPatch(
    const editor_client::Instance& editorInstance,
    const poi_feed::FeedObjectData& patch);
RelocationResult checkRelocationValidity(
    const editor_client::Instance& editorInstance,
    const editor_client::BasicEditorObject& object,
    const poi_feed::FeedObjectData& patch);

bool valid(const RelocationResult&);
std::set<std::string> createMessages(const RelocationResult& relocationResult);
std::string toJson(const std::set<std::string>& messages);

std::optional<editor_client::BasicEditorObject>
getEditorObject(const editor_client::Instance& editor, poi_feed::ObjectId oid);
std::optional<chrono::TimePoint>
getEditorObjectModificationDate(const editor_client::Instance& editor, poi_feed::ObjectId oid);

PoiConflict
poiConflictsPriority(
    const editor_client::Instance& editor,
    const geolib3::Point2& newPositionMercator,
    poi_feed::ObjectId selfId,
    poi_feed::FeedObjectData::IsGeoproduct selfIsGeoproduct);

} // namespace maps::wiki::merge_poi
