#pragma once
#include "common.h"
#include "patches_context.h"
#include "resolution.h"
#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <unordered_set>

namespace maps::wiki::merge_poi {

class Config;
struct StatData;

struct PatchResult
{
    PatchResult() = default;
    PatchResult(Resolution resolution, std::set<std::string> messages)
        : resolution(resolution)
        , messages(std::move(messages))
    {
    }

    chrono::TimePoint processedAt = chrono::TimePoint::clock::now();
    Resolution resolution = Resolution::Skipped;
    std::set<std::string> messages;
};

using ResultsMap = std::unordered_map<poi_feed::ObjectId, PatchResult>;

void processPatches(
    StatData& statistics,
    const PatchesContext& patchesContext,
    MergeTaskId taskId,
    const Config& cfg);

void writeResultsToArchive(
    const ResultsMap& resultsMap,
    const poi_feed::FeedObjectDataVector& candidates,
    MergeTaskId taskId,
    const Config& cfg,
    const PatchResult& defaultPatchResult);

void truncateResultsArchive(const Config& cfg);

} // maps::wiki::merge_poi
