#pragma once

#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <maps/libs/common/include/enum_bitset.h>
#include <unordered_map>
#include <unordered_set>

namespace maps::wiki::merge_poi {
class Config;

enum class PatchModifiedData : unsigned {
    Names,
    Permalink,
    Coordinate,
    EnumBitsetFlagsEnd
};

using PatchModifiedDataFlags = maps::common::EnumBitset<PatchModifiedData>;

class RecentPatches {
public:
    explicit RecentPatches(const Config& cfg);
    const poi_feed::FeedObjectData* find(poi_feed::ObjectId) const;
    PatchModifiedDataFlags compareToStored(const poi_feed::FeedObjectData& newPatch) const;

    void updateStorage(
        const poi_feed::FeedObjectDataVector& patches,
        const std::unordered_set<poi_feed::ObjectId>& modifiedObjectIds) const;

private:
    const Config& cfg_;
    std::unordered_map<poi_feed::ObjectId, poi_feed::FeedObjectData> objectIdToRecentPatch_;
};

} // namespace maps::wiki::merge_poi
