#pragma once

#include "common.h"

#include <string>
#include <cstddef>

namespace maps::wiki::merge_poi {
class Config;

struct CountersByDistance
{
    size_t over500MetersAway = 0;
    size_t over100MetersAway = 0;
    size_t over50MetersAway = 0;
    size_t over20MetersAway = 0;
    size_t over10MetersAway = 0;
    size_t over5MetersAway = 0;
    size_t over1MetersAway = 0;
};

struct StatData
{
public:
    std::string toReportJson() const;
    bool post(const Config& cfg) const;
    void log() const;

    std::atomic<size_t> exported = 0;
    std::atomic<size_t> sprav = 0;
    std::atomic<size_t> outdated = 0;
    std::atomic<size_t> patches = 0;
    std::atomic<size_t> forProtected = 0;
    std::atomic<size_t> rejected = 0;
    std::atomic<size_t> skipped = 0;
    std::atomic<size_t> noSettings = 0;
    std::atomic<size_t> deleted = 0;
    std::atomic<size_t> moved = 0;
    std::atomic<size_t> renamed = 0;
    std::atomic<size_t> feedback = 0;

    std::atomic<size_t> movedAge1d = 0;
    std::atomic<size_t> movedAge2d = 0;
    std::atomic<size_t> movedAge3d = 0;
    std::atomic<size_t> movedAge4d = 0;
    std::atomic<size_t> movedAge5d = 0;
    std::atomic<size_t> movedAge6d = 0;
    std::atomic<size_t> movedAge7d = 0;
    void increaseMovedAge(size_t daysAge);

    size_t toChangeRubric = 0;
    size_t toDelete = 0;
    size_t toMove = 0;
    size_t toRename = 0;

    CountersByDistance toMoveByDistance;

    std::unordered_map<FtTypeId, size_t> feedbackTasksByType;
    size_t increaseFeedbackByType(FtTypeId ftTypeId);

private:
    std::mutex feedbackTasksByTypeMutex;
};

struct RejectsStatData
{
    std::string toReportJson() const;
    bool post(const Config& cfg) const;
    void build(const Config& cfg);

    std::unordered_map<std::string, CountersByDistance> countersByMessage;
};

bool
postStat(const Config& cfg, const std::string& reportName, const std::string& reportBody);

} // maps::wiki::merge_poi
