#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/altay_reader.h>

using namespace maps::wiki::merge_poi;

namespace {
const auto EDITOR_XML_PATH =
    ArcadiaSourceRoot() +
    "/maps/wikimap/mapspro/cfg/editor/editor.xml";
}

Y_UNIT_TEST_SUITE(altay_reader)
{
Y_UNIT_TEST(getNyakExportLocation)
{
    NyakMappingLocations hahnPath;
    UNIT_ASSERT_NO_EXCEPTION(hahnPath = getNyakExportLocation());
    UNIT_ASSERT(!hahnPath.mainUrl.empty());
    UNIT_ASSERT(!hahnPath.unknownUrl.empty());

}
Y_UNIT_TEST(readSomeData)
{
    const EditorCfg editorCfg(EDITOR_XML_PATH);
    const auto langs = supportedNmapsLangs(editorCfg);
    UNIT_ASSERT(langs.count("ru"));
    UNIT_ASSERT(langs.count("en"));
    NyakMappingLocations hahnPath;
    UNIT_ASSERT_NO_EXCEPTION(hahnPath = getNyakExportLocation());
    UNIT_ASSERT(!hahnPath.mainUrl.empty());
    UNIT_ASSERT(!hahnPath.unknownUrl.empty());
    UNIT_ASSERT_NO_EXCEPTION(altayDataDateISO(hahnPath.mainUrl));
    UNIT_ASSERT_NO_EXCEPTION(altayDataDateISO(hahnPath.unknownUrl));
    UNIT_ASSERT_NO_EXCEPTION(IndoorCandidatesData(hahnPath.nyakIndoorCandidatesYTURL, editorCfg, langs, 10));
    UNIT_ASSERT_NO_EXCEPTION(readAltayCompanies(hahnPath.mainUrl, langs, 10));
    UNIT_ASSERT_NO_EXCEPTION(readGeoproductPermalinks());
}
} // Y_UNIT_TEST_SUITE(altay_reader)

