#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/build_patch_feed.h>
#include <maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/helpers.h>

using namespace maps::wiki::merge_poi;

Y_UNIT_TEST_SUITE(build_patch_feed)
{
Y_UNIT_TEST(countProtectedObjects)
{
    const std::string transportDepot = R"(
        {
            "id": "100108169",
            "lat": 55.454168497,
            "lon": 71.692965796,
            "names": [{
                "lang": "ru",
                "name": "остановочный пункт Кочковатский"
            }],
            "revision": "1520450407083",
            "toDelete": false,
            "permalink": "0",
            "shortNames": [
                {
                    "lang": "ru",
                    "name": "Кочковатский"
                }
            ],
            "ftTypeId": 691
        }
        )";
    const std::string transportAirport = R""(
        {
            "id": "100108122",
            "lat": 54.957906085,
            "lon": 73.31645735,
            "names": [
            {
                    "lang": "en",
                    "name": "Omsk Airport"
                },
                {
                    "lang": "ko",
                    "name": "옴 스크 공항 (중앙)"
                }, {
                    "lang": "ru",
                    "name": "аэропорт Омск (Центральный)"
                }
            ],
            "revision": "1532424425661",
            "toDelete": false,
            "permalink": "0",
            "shortNames": [],
            "ftTypeId": 641
        }
        )"";
    poi_feed::FeedObjectDataVector patchData;
    patchData.emplace_back(transportDepot);
    patchData.emplace_back(transportAirport);
    for (const auto& data : patchData) {
        UNIT_ASSERT(data.ftTypeId());
    }
    UNIT_ASSERT_VALUES_EQUAL(countPatchesForProtectedObjects(patchData), 1);
}

Y_UNIT_TEST(filterDeleteSignalForMatchDuplicates)
{
    const std::string patchDataJson1 =
        R"(
            {
                "id": "1",
                "names": [],
                "revision": "1520450407083",
                "toDelete": true,
                "permalink": "124234",
                "shortNames": [],
                "ftTypeId": 691
            }
        )";
    const std::string patchDataJson21 =
        R"(
            {
                "id": "2",
                "names": [],
                "revision": "1520450407083",
                "toDelete": true,
                "permalink": "2",
                "shortNames": [],
                "ftTypeId": 691
            }
        )";
    const std::string patchDataJson22 =
        R"(
            {
                "id": "3",
                "names": [],
                "revision": "1520450407083",
                "toDelete": true,
                "permalink": "2",
                "shortNames": [],
                "ftTypeId": 691
            }
        )";
    poi_feed::FeedObjectDataVector patchData;
    patchData.emplace_back(patchDataJson1);
    patchData.emplace_back(patchDataJson21);
    patchData.emplace_back(patchDataJson22);
    auto rejected = filterDeleteSignalForMatchDuplicates(patchData);
    UNIT_ASSERT_VALUES_EQUAL(rejected.size(), 2);
    UNIT_ASSERT_VALUES_EQUAL(patchData.size(), 1);
    UNIT_ASSERT_VALUES_EQUAL(patchData[0].nmapsId(), 1);
}
} // Y_UNIT_TEST_SUITE(build_patch_feed)
