#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>
#include <maps/wikimap/mapspro/libs/editor_client/impl/parser.h>
#include <maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/feedback.h>

#include <yandex/maps/wiki/unittest/json_schema.h>
#include <yandex/maps/shell_cmd.h>
#include <maps/libs/log8/include/log8.h>
#include <library/cpp/resource/resource.h>

using namespace maps::wiki::merge_poi;
using namespace maps::wiki::editor_client;
using namespace maps::wiki::poi_feed;
using namespace maps::wiki::unittest;

namespace {
const std::string SCHEMAS_PATH_BASE = ArcadiaSourceRoot() + "/maps/wikimap/mapspro/schemas/";
} // namespace

Y_UNIT_TEST_SUITE(feedback)
{
Y_UNIT_TEST(suggested_delete_json)
{
    const std::string poiFinanceJson =
        R"(
            {
                "id": "10",
                "categoryId": "poi_finance",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Point",
                    "coordinates": [
                        33.083332595,
                        68.903093584
                    ]
                },
                "attrs": {
                    "poi_nm": [],
                    "poi_finance:ft_type_id": "1503",
                    "poi_finance:addr_info": "",
                    "poi_finance:open_hours": "",
                    "poi_finance:open_type": "1",
                    "poi_finance:url": "",
                    "poi_finance:email": "",
                    "poi_finance:phone": "",
                    "poi_finance:disp_class": "8",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "poi:business_id": "",
                    "poi:business_rubric_id": "",
                    "sys:blocked": false
                }
            }
        )";
    const std::string patchDataJson =
        R"(
            {
                "id": "10",
                "names": [],
                "revision": "1520450407083",
                "toDelete": true,
                "permalink": "124234",
                "shortNames": [],
                "ftTypeId": 691
            }
        )";
    auto poiFinance = parseJsonResponse(poiFinanceJson);
    FeedObjectData poiFinancePatch(patchDataJson);
    auto taskJson = prepareDeletePoiTaskJsonBody(poiFinancePatch, poiFinance);
    validateJson(taskJson, SCHEMAS_PATH_BASE + "social/social.post.poi_feedback_task.request.schema.json");
}

Y_UNIT_TEST(suggested_move_json)
{
    const std::string poiFinanceJson =
        R"(
            {
                "id": "10",
                "categoryId": "poi_finance",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Point",
                    "coordinates": [
                        33.083332595,
                        68.903093584
                    ]
                },
                "attrs": {
                    "poi_nm": [],
                    "poi_finance:ft_type_id": "1503",
                    "poi_finance:addr_info": "",
                    "poi_finance:open_hours": "",
                    "poi_finance:open_type": "1",
                    "poi_finance:url": "",
                    "poi_finance:email": "",
                    "poi_finance:phone": "",
                    "poi_finance:disp_class": "8",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "poi:business_id": "",
                    "poi:business_rubric_id": "",
                    "sys:blocked": false
                }
            }
        )";
    const std::string patchDataJson =
        R"(
            {
                "id": "10",
                "lon": 33.083493527,
                "lat": 68.903090685,
                "names": [],
                "revision": "1520450407083",
                "toDelete": false,
                "permalink": "0",
                "shortNames": [],
                "ftTypeId": 691
            }
        )";
    FeedObjectData poiFinancePatch(patchDataJson);
    auto poiFinance = parseJsonResponse(poiFinanceJson);
    auto taskJson = prepareMovePoiTaskJsonBody(poiFinancePatch, poiFinance);
    validateJson(
        taskJson,
        SCHEMAS_PATH_BASE +
            "social/social.post.poi_feedback_task.request.schema.json");
}

Y_UNIT_TEST(suggested_create_indoor_poi_json)
{
    const std::string patchDataJson =
        R"(
            {
                "id": "0",
                "lon": 33.083493527,
                "lat": 68.903090685,
                "names": [],
                "revision": "1520450407083",
                "toDelete": false,
                "permalink": "0",
                "shortNames": [],
                "ftTypeId": 691
            }
        )";
    FeedObjectData poiFinancePatch(patchDataJson);
    auto taskJson = prepareCreateIndoorPoiTaskJsonBody(poiFinancePatch);
    validateJson(
        taskJson,
        SCHEMAS_PATH_BASE +
            "social/social.post.poi_feedback_task.request.schema.json");
}

Y_UNIT_TEST(suggested_verify_position_json)
{
    const std::string patchDataJson =
        R"(
            {
                "id": "10",
                "lon": 33.083493527,
                "lat": 68.903090685,
                "names": [],
                "revision": "1520450407083",
                "toDelete": false,
                "permalink": "0",
                "shortNames": [],
                "ftTypeId": 691
            }
        )";
    FeedObjectData poiFinancePatch(patchDataJson);
    auto taskJson = prepareVerifyPositionTaskJsonBody(poiFinancePatch);
    validateJson(
        taskJson,
        SCHEMAS_PATH_BASE +
            "social/social.post.poi_feedback_task.request.schema.json");
}

} // Y_UNIT_TEST_SUITE(feedback)

