#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/indoor_level.h>
#include <geos/geom/GeometryFactory.h>
#include <geos/geom/Point.h>

using namespace maps::wiki::poi_feed;
using namespace maps::wiki::merge_poi;
using namespace maps::wiki::common;

Y_UNIT_TEST_SUITE(IndoorLevel)
{
Y_UNIT_TEST(Contains)
{
    FeedObjectData::Position pos{37.412668, 55.750940};
    FeedObjectData::Position posEast{37.512668, 55.750940};
    geos::geom::Coordinate ptCoord(4164759.1509778, 7473645.96716277);
    geos::geom::Point* geosPt =
        geos::geom::GeometryFactory::getDefaultInstance()->createPoint(ptCoord);
    Geom center(geosPt);
    Geom buffer = center.createBuffer(150.0);
    IndoorLevel level{10, buffer};
    UNIT_ASSERT(level.contains(pos));
    UNIT_ASSERT(!level.contains(posEast));
}
}
