#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>
#include <maps/wikimap/mapspro/libs/editor_client/impl/parser.h>
#include <maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/object_helpers.h>

using namespace maps::wiki::merge_poi;
using namespace maps::wiki::editor_client;
using namespace maps::wiki::poi_feed;

Y_UNIT_TEST_SUITE(object_helpers_small)
{
Y_UNIT_TEST(disp_class)
{
    const std::string bldJson =
        R"(
            {
                "id": "0",
                "categoryId": "bld",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [[[33.083289679, 68.903120641], [33.083281633, 68.903080056], [33.083384564, 68.903077407], [33.083392611, 68.903117992], [33.083289679, 68.903120641]]]
                },
                "attrs": {
                    "bld:ft_type_id": "101",
                    "bld:height": "",
                    "bld:cond": "0",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "sys:blocked": false
                }
            }
        )";

    const std::string poiFinanceJson =
        R"(
            {
                "id": "0",
                "categoryId": "poi_finance",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Point",
                    "coordinates": [
                        33.083332595,
                        68.903093584
                    ]
                },
                "attrs": {
                    "poi_nm": [],
                    "poi_finance:ft_type_id": "1503",
                    "poi_finance:addr_info": "",
                    "poi_finance:open_hours": "",
                    "poi_finance:open_type": "1",
                    "poi_finance:url": "",
                    "poi_finance:email": "",
                    "poi_finance:phone": "",
                    "poi_finance:disp_class": "8",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "poi:business_id": "",
                    "poi:business_rubric_id": "",
                    "sys:blocked": false
                }
            }
        )";
    auto poiFinance = parseJsonResponse(poiFinanceJson);
    auto poiFinanceDispClass = dispClass(poiFinance);
    UNIT_ASSERT(poiFinanceDispClass);
    UNIT_ASSERT_VALUES_EQUAL(poiFinanceDispClass.value(), 8);
    auto bld = parseJsonResponse(bldJson);
    UNIT_ASSERT(!dispClass(bld));
}

Y_UNIT_TEST(is_protected)
{
    const std::string bldJsonProtected =
        R"(
            {
                "id": "0",
                "categoryId": "bld",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [[[33.083289679, 68.903120641], [33.083281633, 68.903080056], [33.083384564, 68.903077407], [33.083392611, 68.903117992], [33.083289679, 68.903120641]]]
                },
                "attrs": {
                    "bld:ft_type_id": "101",
                    "bld:height": "",
                    "bld:cond": "0",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "sys:blocked": false,
                    "sys:protected": true
                }
            }
        )";

    const std::string bldJsonNotProtected =
        R"(
            {
                "id": "0",
                "categoryId": "bld",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [[[33.083289679, 68.903120641], [33.083281633, 68.903080056], [33.083384564, 68.903077407], [33.083392611, 68.903117992], [33.083289679, 68.903120641]]]
                },
                "attrs": {
                    "bld:ft_type_id": "101",
                    "bld:height": "",
                    "bld:cond": "0",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "sys:blocked": false,
                    "sys:protected": false
                }
            }
        )";

    const std::string bldJsonNoAttribute =
        R"(
            {
                "id": "0",
                "categoryId": "bld",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [[[33.083289679, 68.903120641], [33.083281633, 68.903080056], [33.083384564, 68.903077407], [33.083392611, 68.903117992], [33.083289679, 68.903120641]]]
                },
                "attrs": {
                    "bld:ft_type_id": "101",
                    "bld:height": "",
                    "bld:cond": "0",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "sys:blocked": false
                }
            }
        )";

    const std::string bldJsonGarbage =
        R"(
            {
                "id": "0",
                "categoryId": "bld",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [[[33.083289679, 68.903120641], [33.083281633, 68.903080056], [33.083384564, 68.903077407], [33.083392611, 68.903117992], [33.083289679, 68.903120641]]]
                },
                "attrs": {
                    "bld:ft_type_id": "101",
                    "bld:height": "",
                    "bld:cond": "0",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "sys:blocked": false,
                    "sys:protected": "aaa"
                }
            }
        )";

    UNIT_ASSERT(isProtected(parseJsonResponse(bldJsonProtected)));
    UNIT_ASSERT(!isProtected(parseJsonResponse(bldJsonNotProtected)));
    UNIT_ASSERT(!isProtected(parseJsonResponse(bldJsonNoAttribute)));
    UNIT_ASSERT(!isProtected(parseJsonResponse(bldJsonGarbage)));
}

Y_UNIT_TEST(has_verified_coords)
{
   const std::string poiFinanceJson =
        R"(
            {
                "id": "0",
                "categoryId": "poi_finance",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Point",
                    "coordinates": [
                        33.083332595,
                        68.903093584
                    ]
                },
                "attrs": {
                    "poi_nm": [],
                    "poi_finance:ft_type_id": "1503",
                    "poi_finance:addr_info": "",
                    "poi_finance:open_hours": "",
                    "poi_finance:open_type": "1",
                    "poi_finance:url": "",
                    "poi_finance:email": "",
                    "poi_finance:phone": "",
                    "poi_finance:disp_class": "8",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "poi:business_id": "",
                    "poi:business_rubric_id": "",
                    "sys:blocked": false
                }
            }
        )";
    UNIT_ASSERT(!hasVerifiedCoordinates(parseJsonResponse(poiFinanceJson)));
    const std::string poiFinanceJsonUser =
        R"(
            {
                "id": "0",
                "categoryId": "poi_finance",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Point",
                    "coordinates": [
                        33.083332595,
                        68.903093584
                    ]
                },
                "attrs": {
                    "poi_nm": [],
                    "poi_finance:ft_type_id": "1503",
                    "poi_finance:addr_info": "",
                    "poi_finance:open_hours": "",
                    "poi_finance:open_type": "1",
                    "poi_finance:url": "",
                    "poi_finance:email": "",
                    "poi_finance:phone": "",
                    "poi_finance:disp_class": "8",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "poi:business_id": "",
                    "poi:business_rubric_id": "",
                    "sys:blocked": false,
                    "poi:position_quality": "user"
                }
            }
        )";
    UNIT_ASSERT(hasVerifiedCoordinates(parseJsonResponse(poiFinanceJsonUser)));
    const std::string poiFinanceJsonPrecise =
        R"(
            {
                "id": "0",
                "categoryId": "poi_finance",
                "revisionId": "1:1",
                "state": "draft",
                "geometry": {
                    "type": "Point",
                    "coordinates": [
                        33.083332595,
                        68.903093584
                    ]
                },
                "attrs": {
                    "poi_nm": [],
                    "poi_finance:ft_type_id": "1503",
                    "poi_finance:addr_info": "",
                    "poi_finance:open_hours": "",
                    "poi_finance:open_type": "1",
                    "poi_finance:url": "",
                    "poi_finance:email": "",
                    "poi_finance:phone": "",
                    "poi_finance:disp_class": "8",
                    "sys:import_source": "",
                    "sys:import_source_id": "",
                    "poi:business_id": "",
                    "poi:business_rubric_id": "",
                    "sys:blocked": false,
                    "poi:position_quality": "precise"
                }
            }
        )";
    UNIT_ASSERT(hasVerifiedCoordinates(parseJsonResponse(poiFinanceJsonPrecise)));
}

} // Y_UNIT_TEST_SUITE(object_helpers_small)

