#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/libs/editor_client/include/instance.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/exception.h>
#include <maps/wikimap/mapspro/libs/editor_client/impl/parser.h>
#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/object_helpers.h>
#include <yandex/maps/wiki/common/robot.h>
#include <maps/libs/log8/include/log8.h>

using namespace maps::wiki::merge_poi;
using namespace maps::wiki::editor_client;
using namespace maps::wiki::poi_feed;
/*
* For these tests to run you need working and accessible wiki-editor backend
*/
namespace {
const std::string EDITOR_BACKEND_URL = "http://core-nmaps-editor.common.unstable.maps.yandex.net" ;
namespace test_data {
const std::string bldCurJson =
    R"(
        {
            "id": "0",
            "categoryId": "bld",
            "revisionId": "1:1",
            "state": "draft",
            "geometry": {
                "type": "Polygon",
                "coordinates": [[[33.083289679, 68.903120641], [33.083281633, 68.903080056], [33.083384564, 68.903077407], [33.083392611, 68.903117992], [33.083289679, 68.903120641]]]
            },
            "attrs": {
                "bld:ft_type_id": "101",
                "bld:height": "",
                "bld:cond": "0",
                "sys:import_source": "",
                "sys:import_source_id": "",
                "sys:blocked": false
            }
        }
    )";
const std::string bldDstJson =
    R"(
        {
            "id": "0",
            "categoryId": "bld",
            "revisionId": "1:1",
            "state": "draft",
            "geometry": {
                "type": "Polygon",
                "coordinates": [[[33.083466705, 68.903114843], [33.083458658, 68.903077157], [33.083556496, 68.903074446], [33.083564543, 68.903112131], [33.083466705, 68.903114843]]]
            },
            "attrs": {
                "bld:ft_type_id": "101",
                "bld:height": "",
                "bld:cond": "0",
                "sys:import_source": "",
                "sys:import_source_id": "",
                "sys:blocked": false
            }
        }
    )";
const std::string poiFinanceJson =
    R"(
        {
            "id": "0",
            "categoryId": "poi_finance",
            "revisionId": "1:1",
            "state": "draft",
            "geometry": {
                "type": "Point",
                "coordinates": [
                    33.083332595,
                    68.903093584
                ]
            },
            "attrs": {
                "poi_nm": [],
                "poi_finance:ft_type_id": "1503",
                "poi_finance:addr_info": "",
                "poi_finance:open_hours": "",
                "poi_finance:open_type": "1",
                "poi_finance:url": "",
                "poi_finance:email": "",
                "poi_finance:phone": "",
                "poi_finance:disp_class": "8",
                "sys:import_source": "",
                "sys:import_source_id": "",
                "poi:business_id": "",
                "poi:business_rubric_id": "",
                "sys:blocked": false
            }
        }
    )";
const std::string addrJson =
    R"(
        {
            "id": "0",
            "categoryId": "addr",
            "revisionId": "1:1",
            "state": "draft",
            "geometry": {
                "type": "Point",
                "coordinates": [
                    33.083332595,
                    68.903093584
                ]
            },
            "attrs": {
                "addr_nm": [
                    {
                        "addr_nm:is_local": true,
                        "addr_nm:lang": "ru",
                        "addr_nm:name": "33",
                        "addr_nm:name_type": "official"
                    }
                ],
                "addr:disp_class": "5",
                "sys:import_source": "",
                "sys:import_source_id": "",
                "sys:blocked": false
            }
        }
    )";
const std::string poiEntranceJson =
    R"(
        {
            "id": "0",
            "categoryId": "poi_entrance",
            "revisionId": "1:1",
            "state": "draft",
            "geometry": {
                "type": "Point",
                "coordinates": [33.083493527, 68.903090685]
            },
            "attrs": {
                "poi_nm": [],
                "poi_entrance:disp_class": "7",
                "sys:blocked": false
            }
        }
    )";
const std::string patchDataJson =
    R"(
        {
            "id": "0",
            "lon": 33.083493527,
            "lat": 68.903090685,
            "names": [],
            "revision": "1520450407083",
            "toDelete": false,
            "permalink": "0",
            "shortNames": [],
            "ftTypeId": 691
        }
    )";
} // namespace test_data

struct Cleanup
{
    Cleanup(Instance& instance)
        : instance(instance)
    {}
    ~Cleanup()
    {
        for (const auto id : toDelete) {
            instance.deleteObject(id);
        }
    }
    Instance& instance;
    std::set<ObjectId> toDelete;
};
} // namespace

Y_UNIT_TEST_SUITE(object_helpers)
{
Y_UNIT_TEST(checkRelocationValidity)
{


    Instance instance(EDITOR_BACKEND_URL, maps::wiki::common::WIKIMAPS_SPRAV_UID);
    Cleanup obstaclesDeleter(instance);
    try {
        FeedObjectData poiFinancePatch(test_data::patchDataJson);
        auto poiFinanceId = instance.saveObject(parseJsonResponse(test_data::poiFinanceJson)).id;
        obstaclesDeleter.toDelete.insert(poiFinanceId);
        //No obstacles
        UNIT_ASSERT(
            valid(checkRelocationValidity(instance, instance.getObjectById(poiFinanceId), poiFinancePatch)));
        //Entrance at new position
        obstaclesDeleter.toDelete.insert(instance.saveObject(parseJsonResponse(test_data::poiEntranceJson)).id);
        auto r1 = checkRelocationValidity(instance, instance.getObjectById(poiFinanceId), poiFinancePatch);
        UNIT_ASSERT(valid(r1));
        UNIT_ASSERT(r1.entranceCollision == EntranceCollision::True);
        //Next more important than entrance
        //Bld at cur position no bld at new position
        obstaclesDeleter.toDelete.insert(instance.saveObject(parseJsonResponse(test_data::bldCurJson)).id);
        auto r2 = checkRelocationValidity(instance, instance.getObjectById(poiFinanceId), poiFinancePatch);
        UNIT_ASSERT(!valid(r2));
        UNIT_ASSERT(r2.bldChange == BldChange::True);
        //Other bld at new position
        obstaclesDeleter.toDelete.insert(instance.saveObject(parseJsonResponse(test_data::bldDstJson)).id);
        auto r3 = checkRelocationValidity(instance, instance.getObjectById(poiFinanceId), poiFinancePatch);
        UNIT_ASSERT(!valid(r3));
        UNIT_ASSERT(r3.bldChange == BldChange::True);
        UNIT_ASSERT(hasIsGeoproductAttr(instance.getObjectById(poiFinanceId)));
    } catch (const ServerException& sex) {
        UNIT_FAIL(sex.serverResponse());
    }
    //TODO Check with ADDR: Problem - addr to rd binding required. not supported by EditorClient
    /*
        //Addr at new postion too, more important than bld
        try {
        obstaclesDeleter.toDelete.insert(instance.saveObject(parseJsonResponse(addrJson)));
        } catch (const ServerException& sex) {
            UNIT_FAIL(sex.serverResponse());
        }
        UNIT_ASSERT(
            checkRelocationValidity(instance, instance.getObjectById(poiFinanceId), poiFinancePatch)
            == RelocationValidity::AddrCollision);
    */
}

} // Y_UNIT_TEST_SUITE(build_patch_feed)
