#pragma once

#include "common.h"
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/chrono/include/time_point.h>
#include <optional>
#include <set>

namespace maps::wiki::toloka_downloader {

class Assignment
{
public:
    using PhotoUrls = std::set<std::string>;

    struct Data {
        chrono::TimePoint submitTs;
        PhotoUrls photoUrls;
        geolib3::Point2 objectPosition{0, 0};
        geolib3::Point2 workerPosition{0, 0};
        std::optional<std::string> comment;
        std::optional<std::string> nmapsObjectId;
    };

    Assignment(PoolId poolId, AssignmentId id)
        : poolId_(poolId)
        , id_(std::move(id))
    {}

    PoolId poolId() const { return poolId_; }
    const AssignmentId& id() const { return id_; }

    const Data& data() const { return data_; }
    void setData(Data data) { data_ = std::move(data); }

private:
    PoolId poolId_;
    AssignmentId id_;
    Data data_;
};

} // namespace maps::wiki::toloka_downloader
