#include "common.h"

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::toloka_downloader {

namespace {

constexpr enum_io::Representations<TaskType> TASK_TYPE_ENUM_REPRESENTATION {
    {TaskType::Entrance, "entrance"},
};

constexpr enum_io::Representations<TaskStatus> TASK_STATUS_ENUM_REPRESENTATION {
    {TaskStatus::Processing, "processing"},
    {TaskStatus::Ok, "ok"},
    {TaskStatus::Failed, "failed"},
};

} // namespace

DEFINE_ENUM_IO(TaskType, TASK_TYPE_ENUM_REPRESENTATION);
DEFINE_ENUM_IO(TaskStatus, TASK_STATUS_ENUM_REPRESENTATION);

} // namespace maps::wiki::toloka_downloader
