#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <cstdint>
#include <string>
#include <vector>

namespace maps::wiki::toloka_downloader {

using AssignmentId = std::string;
using AttachmentId = std::string;
using PhotoId = std::string;
using PoolId = uint64_t;

struct Attachment
{
    AttachmentId id;
    std::string data;
};

using AttachmentIds = std::vector<AttachmentId>;
using Attachments = std::vector<Attachment>;


enum class TaskType { Entrance };

DECLARE_ENUM_IO(TaskType);


enum class TaskStatus { Processing, Ok, Failed };

DECLARE_ENUM_IO(TaskStatus);


struct Stats {
    size_t ok = 0;
    size_t failed = 0;
    size_t skipped = 0;
    size_t duplicated = 0;
};

} // namespace maps::wiki::toloka_downloader
