#pragma once

#include "assignment.h"
#include "common.h"

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/pgpool3_helpers.h>

#include <map>
#include <vector>

namespace maps::wiki::toloka_downloader {

class Database
{
public:
    Database(const common::ExtendedXmlDoc& config, TaskType taskType);

    std::vector<PoolId> loadPoolIds();

    std::vector<AssignmentId> loadAssignmentIds(PoolId poolId);


    bool saveAssignment(
        const Assignment& assignment,
        TaskStatus status);

    bool updateAssignmentData(
        const Assignment& assignment);

    bool updateStatus(
        const Assignment& assignment,
        TaskStatus status);

    std::map<AttachmentId, PhotoId> loadSavedPhotoIds(
        const Assignment& assignment);

    bool saveAttachments(
        const Assignment& assignment,
        const std::map<AttachmentId, PhotoId>& attachmentToPhotoIds);

    pgpool3::Pool& socialPool() { return socialPool_.pool(); }
    TaskType taskType() const { return taskType_; }

private:
    wiki::common::PoolHolder socialPool_;
    TaskType taskType_;
};

} // namespace maps::wiki::toloka_downloader
