#pragma once

#include "common.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/http/include/http.h>
#include <maps/libs/geolib/include/point.h>
#include <functional>
#include <map>

namespace maps::wiki::toloka_downloader {

using TvmTicketProvider = std::function<std::string()>;

struct ImageData
{
    std::string original;
    std::string shrinked;
    size_t shrinkScale = 1; // 2 -> w/2, h/2

    const std::string& data() const
    { return shrinked.empty() ? original : shrinked; }
};

struct Photo
{
    ImageData image;
    geolib3::Point2 workerCoordinate;
    double azimuth{0};
    chrono::TimePoint takenAt;
};

struct CreateObjectRequest
{
    TaskType taskType{TaskType::Entrance};
    geolib3::Point2 objectCoordinate{0,0};
    std::optional<std::string> comment;
    std::optional<std::string> nmapsObjectId;
    std::map<AttachmentId, Photo> photos;
};

struct CreateObjectResponse
{
    std::map<AttachmentId, PhotoId> attachmentToPhotoIds;
};

class MrcClient
{
public:
    explicit MrcClient(std::string mrcApiUrl);

    void setTvmTicketProvider(TvmTicketProvider tvmTicketProvider)
    {
        tvmTicketProvider_ = std::move(tvmTicketProvider);
    }

    CreateObjectResponse submit(CreateObjectRequest& createObjectRequest);

private:
    const std::string mrcApiUrl_;
    TvmTicketProvider tvmTicketProvider_;
    http::Client httpClient_;
};

} // namespace maps::wiki::toloka_downloader
