#pragma once

#include "database.h"
#include "mrc_client.h"
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>

namespace maps::wiki::toloka_downloader {

struct RunOptions
{
    bool updateAssignmentData = false;
};

class Worker
{
public:
    Worker(
        const common::ExtendedXmlDoc& config,
        const std::string& tvmAlias,
        TaskType taskType);

    Stats run(const std::string& ytTable, const RunOptions& runOptions);

    Database& database() { return database_; }

private:
    Database database_;
    MrcClient mrcClient_;
};

} // namespace maps::wiki::toloka_downloader
