#include "yt_reader.h"

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::toloka_downloader {

namespace {
const TString YT_REALM = "hahn";
} // namespace

YtReader::YtReader()
{
    NYT::JoblessInitialize();
}

Stats YtReader::readData(const std::string& table)
{
    INFO() << "Loading data from YT: " << table;
    auto client = common::yt::createYtClient(YT_REALM);
    auto reader = client->CreateTableReader<NYT::TNode>(TString(table));

    Stats stats;
    size_t size = 0;
    for (; reader->IsValid(); reader->Next()) {
        switch (readRow(reader->GetRow())) {
            case Result::Ok:
                ++stats.ok;
                break;
            case Result::Skipped:
                ++stats.skipped;
                break;
            case Result::Failed:
                ++stats.failed;
                break;
            case Result::Duplicated:
                ++stats.duplicated;
                break;
        }
        ++size;
    }
    INFO() << "Processed " << size << " rows from YT: " << table
           << " (skipped: " << stats.skipped
           << ", failed: " << stats.failed
           << ", duplicated: " << stats.duplicated << ")";
    return stats;
}

} // namespace maps::wiki::toloka_downloader
