#pragma once

#include "common.h"
#include <yandex/maps/wiki/common/yt.h>
#include <string>

namespace maps::wiki::toloka_downloader {

class YtReader
{
public:
    YtReader();
    virtual ~YtReader() = default;

    Stats readData(const std::string& table);

protected:
    enum class Result { Ok, Skipped, Failed, Duplicated };

    virtual Result readRow(const NYT::TNode& row) = 0;
};

} // namespace maps::wiki::toloka_downloader
