#pragma once
#include "common.h"
#include "config.h"
#include "yt_reader.h"
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::walkers_export_downloader {

using BundleId = uint64_t;
using FeedbackTaskId = uint64_t;

struct PhotoData
{
    PhotoId photoId;
    PhotoSubject subject = PhotoSubject::Facade;
    geolib3::Point2 shootingPoint;
    geolib3::Point2 shootingTarget;
    bool operator ==(const PhotoData& other) const = default;
};

struct CompanyDataBundle
{
    enum class State {
        Draft,
        Waiting,
        Submitted,
        Canceled,
        Failed
    };

    BundleId id;
    PermalinkId permalinkId;
    maps::chrono::TimePoint createdAt;
    State state;
    geolib3::Point2 coordinate;
    std::optional<maps::chrono::TimePoint> submittedAt;
    std::optional<FeedbackTaskId> feedbackTaskId;
    std::vector<PhotoData> photos;
};

DECLARE_ENUM_IO(CompanyDataBundle::State);

class CompanyDataBundleQueue
{
public:
    explicit CompanyDataBundleQueue(pgpool3::Pool& socialPool);

    BundleId createBundle(
        PermalinkId permalinkId, const geolib3::Point2& poiCoordinate);

    std::vector<BundleId> findBundles(PermalinkId permalinkId, CompanyDataBundle::State state) const;

    void assignPhotoToBundle(BundleId id, const PhotoId& photoId);

    void setBundleState(BundleId id, CompanyDataBundle::State state);

    void markAsSubmitted(BundleId id, FeedbackTaskId taskId);

    std::vector<CompanyDataBundle> load(const std::vector<BundleId>& ids) const;

    std::vector<CompanyDataBundle> loadWaitingBatch(BundleId minId, size_t count) const;

    size_t waitingCount() const;

    std::optional<maps::chrono::TimePoint> oldestWaitingCreatedAt() const;

    std::optional<PhotoData> loadPhotoData(const PhotoId& photoId) const;

    void storePhotoData(const PhotoData& data);

private:
    pgpool3::Pool& socialPool_;
};

} // namespace maps::wiki::walkers_export_downloader
