#include "config.h"
#include <maps/libs/auth/include/tvm.h>

using namespace std::string_literals;

namespace maps::wiki::walkers_export_downloader {

namespace {

const auto MRC_AGENT_PROXY_URL_XPATH = "/config/services/mrc-agent-proxy/url"s;
const auto MRC_BROWSER_URL_XPATH = "/config/services/mrc-browser-external/url"s;
const auto MRC_BROWSER_PRO_URL_XPATH = "/config/services/mrc-browser-pro-external/url"s;
const auto SOCIAL_BACKOFFICE_URL_XPATH = "/config/services/social-backoffice/url"s;
const auto EDITOR_URL_XPATH = "/config/services/editor/url"s;

} // namespace

Config::Config(const common::ExtendedXmlDoc& configXml)
    : socialPool_(configXml, "social", "grinder")
    , mrcPool_(configXml, "mrc", "grinder")
    , mrcAgentProxyUrl_(configXml.get<std::string>(MRC_AGENT_PROXY_URL_XPATH))
    , mrcBrowserUrl_(configXml.get<std::string>(MRC_BROWSER_URL_XPATH))
    , mrcBrowserProUrl_(configXml.get<std::string>(MRC_BROWSER_PRO_URL_XPATH))
    , socialBackofficeUrl_(configXml.get<std::string>(SOCIAL_BACKOFFICE_URL_XPATH))
    , editorUrl_(configXml.get<std::string>(EDITOR_URL_XPATH))
{
}

void Config::initTvm()
{
    auto tvmToolSettings =
        maps::auth::TvmtoolSettings().selectClientAlias("maps-core-nmaps-tasks-sprav");
    auto tvmClient = std::make_shared<NTvmAuth::TTvmClient>(tvmToolSettings.makeTvmClient());

    mrcAgentProxyTvmTicketProvider_ = [tvmClient]() {
        return tvmClient->GetServiceTicketFor("mrc-agent-proxy");
    };

    socialBackofficeTvmTicketProvider_ = [tvmClient]() {
        return tvmClient->GetServiceTicketFor("social-backoffice");
    };
}

} // namespace maps::wiki::walkers_export_downloader
