#pragma once

#include "mrc_client.h"

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

namespace maps::wiki::walkers_export_downloader {

class Config {
public:
    explicit Config(const common::ExtendedXmlDoc& configXml);

    pgpool3::Pool& socialPool() const
    { return socialPool_.pool(); }

    pgpool3::Pool& mrcPool() const
    { return mrcPool_.pool(); }

    const TvmTicketProvider& mrcAgentProxyTvmTicketProvider() const
    { return mrcAgentProxyTvmTicketProvider_; }

    const std::string& mrcAgentProxyUrl() const
    { return mrcAgentProxyUrl_; }

    const std::string& mrcBrowserUrl() const
    { return mrcBrowserUrl_; }
    const std::string& mrcBrowserProUrl() const
    { return mrcBrowserProUrl_; }

    TvmTicketProvider socialBackofficeTvmTicketProvider() const
    { return socialBackofficeTvmTicketProvider_; }

    const std::string& socialBackofficeUrl() const
    { return socialBackofficeUrl_; }

    const std::string& editorUrl() const { return editorUrl_; }

    void initTvm();


private:
    mutable common::PoolHolder socialPool_;
    mutable common::PoolHolder mrcPool_;
    TvmTicketProvider mrcAgentProxyTvmTicketProvider_;
    const std::string mrcAgentProxyUrl_;
    const std::string mrcBrowserUrl_;
    const std::string mrcBrowserProUrl_;
    TvmTicketProvider socialBackofficeTvmTicketProvider_;
    const std::string  socialBackofficeUrl_;
    const std::string editorUrl_;
};

} // namespace maps::wiki::walkers_export_downloader
