#pragma once

#include "common.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/http/include/http.h>

#include <functional>

namespace maps::wiki::walkers_export_downloader {

using TvmTicketProvider = std::function<std::string()>;

struct CreatePhotoRequest
{
    std::string image;
    geolib3::Point2 coordinate;
    double azimuth{0};
    chrono::TimePoint takenAt;
};

struct CreateObjectRequest
{
    std::string image;
    geolib3::Point2 coordinate;
    geolib3::Point2 target;
    chrono::TimePoint takenAt;
};

std::string
toMessage(const CreatePhotoRequest& createPhotoRequest);

std::string
toMessage(const CreateObjectRequest& createObjectRequest);

class MrcClient
{
public:
    explicit MrcClient(std::string mrcApiUrl);

    void setTvmTicketProvider(TvmTicketProvider tvmTicketProvider)
    {
        tvmTicketProvider_ = std::move(tvmTicketProvider);
    }

    PhotoId submitPhoto(const CreatePhotoRequest& createPhotoRequest);
    PhotoId submitObject(const CreateObjectRequest& createObjectRequest);

private:
    const std::string mrcApiUrl_;
    TvmTicketProvider tvmTicketProvider_;
    http::Client httpClient_;
};

} // namespace maps::wiki::walkers_export_downloader
