#pragma once

#include "common.h"
#include "company_data_bundle_queue.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>

namespace mrc_db = maps::mrc::db;
namespace editor = maps::wiki::editor_client;

namespace maps::wiki::walkers_export_downloader::helpers {

struct MrcUrls
{
    const std::string& common;
    const std::string& pro;
};

bool areAllPhotosProcessed(const std::map<PhotoId, mrc_db::Feature>& mrcFeatures);

std::map<PhotoId, mrc_db::Feature>
removeNotPublished(std::map<PhotoId, mrc_db::Feature> mrcFeatures);

std::string
makeRequestBody(
    const std::map<PhotoId, mrc_db::Feature>& mrcFeatures,
    const CompanyDataBundle& bundle,
    const std::optional<editor::BasicEditorObject>& nmapsObject,
    const MrcUrls& mrcUrls);

} // namespace maps::wiki::walkers_export_downloader::helpers
