#pragma once

#include "common.h"
#include "config.h"
#include "mrc_client.h"

#include <set>
#include <unordered_map>

namespace maps::wiki::walkers_export_downloader {

class Storage
{
public:
    using PhotoKey = std::string;

    Storage(const Config& cfg);

    std::optional<PhotoId> findPhoto(const PhotoKey& key) const;

    void assignToCompany(const PhotoId& photoId, PermalinkId permalinkId);

    void commitChanges() const;

    std::optional<PhotoId> createObjectPhoto(
        const PhotoKey& key,
        const geolib3::Point2& coordinate,
        const geolib3::Point2& target,
        chrono::TimePoint takenAt,
        std::string image);

private:
    void writeNewVersionRows(uint64_t versionId) const;

    const Config& cfg_;
    MrcClient mrcClient_;
    std::unordered_map<PhotoKey, PhotoId> photoIdsByKey_;
    std::unordered_map<PermalinkId, std::set<PhotoId>> photoIdsByPermalink_;
};

} // namespace maps::wiki::walkers_export_downloader
