#pragma once

#include "common.h"
#include "config.h"

#include <maps/wikimap/mapspro/libs/poi_feed/include/types.h>

#include <deque>
#include <map>
#include <set>
#include <string>
#include <vector>
#include <unordered_set>

namespace maps::wiki::walkers_export_downloader {

using POICoords = std::unordered_map<poi_feed::PermalinkId, geolib3::Point2>;

struct WalkersPhotoData
{
    std::string downloadUrl;
    PhotoSubject subject = PhotoSubject::Facade;
    std::optional<geolib3::Point2> coordTaking;
    std::optional<geolib3::Point2> coordObject;
    maps::chrono::TimePoint submitTs;
};

struct WalkersExportData
{
    PermalinkId permalinkId;
    maps::chrono::TimePoint actualizationDate;
    std::vector<std::string> photos;
    std::optional<geolib3::Point2> defaultShootingTarget;
};

using WalkersPhotoDatas = std::deque<WalkersPhotoData>;
using WalkersExportDatas = std::deque<WalkersExportData>;

struct WalkersYtData
{
    WalkersPhotoDatas photoDatas;
    WalkersExportDatas exportDatas;
};

struct ReaderContext
{
    std::unordered_set<uint64_t> seenWalkersTasksIds;
    POICoords poiCoordinates;

    std::optional<geolib3::Point2> poiCoordinate(PermalinkId) const;
};

WalkersYtData readWalkersYtData(ReaderContext& readerContext, size_t limit = 0);
WalkersYtData readRawDesktopWalkersYtData(ReaderContext& readerContext, size_t limit = 0);

POICoords readAltayPOICoordinates();

} // namespace maps::wiki::walkers_export_downloader
