#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/services/tasks_sprav/src/walkers_export_downloader/lib/mrc_client.h>
#include <yandex/maps/proto/mrc/backoffice/backoffice.pb.h>

namespace maps::wiki::walkers_export_downloader::tests {

namespace {

// ya tool tvmknife get_service_ticket sshkey -s 2027196 -d 2015971
std::string getTestTicket()
{
    return "<ticket>";
}

} // namespace

Y_UNIT_TEST_SUITE(mrc_client)
{

Y_UNIT_TEST(create_message_photo)
{
    CreatePhotoRequest request;
    std::string message;
    UNIT_ASSERT_NO_EXCEPTION(message = toMessage(request));
    auto createPhotoRequest =
        yandex::maps::proto::mrc::backoffice::CreatePhotoRequest{};
    UNIT_ASSERT(createPhotoRequest.ParseFromString(TString{message}));
}

Y_UNIT_TEST(create_message_object)
{
    CreateObjectRequest request;
    std::string message;
    UNIT_ASSERT_NO_EXCEPTION(message = toMessage(request));
    auto createObjectRequest =
        yandex::maps::proto::mrc::backoffice::CreateObjectRequest{};
    UNIT_ASSERT(createObjectRequest.ParseFromString(TString{message}));
}

Y_UNIT_TEST(test_submit_photo)
{
    if (getTestTicket() == "<ticket>") {
        return;
    }
    MrcClient mrcClient("http://core-nmaps-mrc-agent-proxy.common.testing.maps.yandex.net");
    mrcClient.setTvmTicketProvider(getTestTicket);
    CreatePhotoRequest request {
        .image = "test",
        .coordinate = geolib3::Point2(30, 30),
        .azimuth = 0,
        .takenAt = maps::chrono::convertFromUnixTime(std::time(nullptr))
    };
    auto id = mrcClient.submitPhoto(request);
    UNIT_ASSERT(id.length());
}

} // Y_UNIT_TEST_SUITE(mrc_client)

} // namespace  maps::wiki::walkers_export_downloader::tests
