#include "assignment.h"

#include <maps/libs/common/include/exception.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/string_utils.h>

namespace maps::wiki::yang {

namespace {
const std::string EMPTY;
} //namespace

const Assignment::Id& Assignment::id() const
{
    const auto& value = get("assignment_assignment_id");
    REQUIRE(!value.empty(), "Assignment id not found");
    return value;
}

void Assignment::add(const std::string& key, std::string value)
{
    ASSERT(data_.try_emplace(key, std::move(value)).second);
}

const std::string& Assignment::get(const std::string& key) const
{
    auto it = data_.find(key);
    return it != data_.end() ? it->second : EMPTY;
}

const std::string& Assignment::status() const
{
    return get("assignment_status");
}

const std::string& Assignment::objectKind() const
{
    return get("output_object_kind");
}

AttachmentIds Assignment::objectPhotos() const
{
    return common::split(get("output_object_photos"), ",");
}

} // namespace maps::wiki::yang
