#pragma once

#include "common.h"
#include <map>

namespace maps::wiki::yang {

class Assignment
{
public:
    using Id = std::string;
    using Data = std::map<std::string, std::string>;

    Assignment() = default;

    const Id& id() const;

    const Data& data() const { return data_; }

    void add(const std::string& key, std::string value);

    const std::string& get(const std::string& key) const;

    const std::string& status() const;
    const std::string& objectKind() const;
    AttachmentIds objectPhotos() const;

private:
    Data data_;
};

using Assignments = std::vector<Assignment>;

} // namespace maps::wiki::yang
