#pragma once

#include "assignment.h"
#include "common.h"

#include <yandex/maps/mrc/toloka_client/client.h>
#include <deque>

namespace maps::wiki::yang {

class Client
{
public:
    Client(const std::string& oauthToken, ProjectId projectId);

    std::deque<PoolId> getClosedPoolIds() const;

    void listClosedPools() const;

    bool archivePool(PoolId poolId) const;

    void dumpPool(PoolId poolId) const;

    Assignments loadAssignments(PoolId poolId) const;

    Attachments loadAttachments(const AttachmentIds& attachmentIds) const;

private:
    maps::mrc::toloka::io::TolokaClient client_;
    ProjectId projectId_;
};

} // namespace maps::wiki::yang
