#pragma once

#include "common.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/http/include/http.h>
#include <maps/libs/geolib/include/point.h>
#include <functional>
#include <map>

namespace maps::wiki::yang {

using TvmTicketProvider = std::function<std::string()>;

struct Photo
{
    std::string image;
    geolib3::Point2 workerCoordinate;
    double azimuth;
    chrono::TimePoint takenAt;
};

struct CreateObjectRequest
{
    std::string objectKind;
    geolib3::Point2 objectCoordinate;
    std::string comment;
    std::map<AttachmentId, Photo> photos;
};

struct CreateObjectResponse
{
    std::map<AttachmentId, PhotoId> attachmentToPhotoIds;
};

class MrcClient
{
public:
    explicit MrcClient(const std::string& mrcApiUrl);

    void setTvmTicketProvider(TvmTicketProvider tvmTicketProvider)
    {
        tvmTicketProvider_ = std::move(tvmTicketProvider);
    }

    CreateObjectResponse submit(const CreateObjectRequest& createPhotoRequest);

private:
    const std::string mrcApiUrl_;
    TvmTicketProvider tvmTicketProvider_;
    http::Client httpClient_;
};

} // namespace maps::wiki::yang
