#!/bin/bash

BATCH_LIMIT=$1
if [ -z "$BATCH_LIMIT" ]; then
    echo "Empty batch limit"
    exit 1
fi

STAGING="stable"
CONFIG="../../../../../cfg/services/services.$STAGING.$USER.xml"
TVM_ALIAS="maps-core-nmaps-tasks-sprav-$STAGING"

../bin/wiki-yang-downloader 2>&1 \
    --config $CONFIG \
    --batch-limit $BATCH_LIMIT \
    --tvm-alias $TVM_ALIAS \
    --actions dump,upload,archive
