#pragma once

#include <yandex/maps/wiki/common/geom.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/tasks/task_logger.h>
#include <yandex/maps/wiki/diffalert/revision/diff_context.h>
#include <yandex/maps/wiki/diffalert/storage/stored_message.h>
#include <yandex/maps/wiki/configs/editor/config_holder.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/libs/csv/include/output_stream.h>

#include <filesystem>
#include <list>
#include <mutex>
#include <unordered_map>

namespace maps::wiki::diffalert {

using DescriptionToMessages = std::unordered_map<std::string, std::list<StoredMessage>>;
using AoiToDescriptionToMessages = std::unordered_map<std::string, DescriptionToMessages>;

struct Aoi
{
    std::string name;
    common::Geom geom;
};

class CsvCategoryWriter
{
public:
    CsvCategoryWriter(
        const configs::editor::Category& category,
        const std::vector<Aoi>& aois);

    void put(
        const LongtaskDiffContext& diffContext,
        const std::list<StoredMessage>& messages);

    void writeTo(const std::filesystem::path& workDir);

private:
    void pushAttributes(
        const LongtaskDiffContext& diffContext,
        std::vector<std::string>& objectCsvRow) const;
    void pushNames(
        const LongtaskDiffContext& diffContext,
        std::vector<std::string>& objectCsvRow) const;

    void writeCsvHeader(csv::OutputStream& csvStream) const;

    const configs::editor::Category& category_;
    const std::vector<Aoi>& aois_;

    std::vector<std::string> attrIds_;

    std::mutex mutex_;

    AoiToDescriptionToMessages aoiToDescriptionToMessages_;
    std::unordered_map<TId, std::vector<std::string>> objectIdToCsvRow_;
};

class CsvWriter
{
public:
    CsvWriter(
        const configs::editor::ConfigHolder& editorConfig,
        std::vector<Aoi> aois);

    void put(
        const LongtaskDiffContext& diffContext,
        const std::list<StoredMessage>& messages);

    void publishToMds(
        int64_t taskId,
        const common::ExtendedXmlDoc& config,
        pgpool3::Pool& corePool,
        tasks::TaskPgLogger& taskLogger);

private:
    const configs::editor::ConfigHolder& editorConfig_;
    std::vector<Aoi> aois_;

    std::unordered_map<std::string, CsvCategoryWriter> categoryToWriter_;
};

} // maps::wiki::diffalert
