#include "taskdata.h"

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::diffalert_worker {

TaskData::TaskData(pqxx::transaction_base& txnCore, DBID taskId)
    : taskId(taskId)
{
    auto query =
        "SELECT *, (LENGTH(log) > 0) AS already_started"
        " FROM service.diffalert_task dt"
        " JOIN service.task t USING(id)"
        " WHERE id=" + std::to_string(taskId);

    auto result = txnCore.exec(query);
    ASSERT(result.size() == 1);

    const auto& row = result[0];

    grinderTaskId = row["grinder_task_id"].as<std::string>({});
    ytOperationId = row["yt_operation_id"].as<std::string>({});
    oldBranchId = row["old_branch_id"].as<DBID>();
    oldCommitId = row["old_commit_id"].as<DBID>();
    newBranchId = row["new_branch_id"].as<DBID>();
    newCommitId = row["new_commit_id"].as<DBID>();
    withImportedObjects = row["with_imported_objects"].as<bool>();
    userFilter = row["user_filter"].as<std::string>("all");
    alreadyStarted = row["already_started"].as<bool>();
}

void TaskData::dump() const
{
    INFO() << "Taskdata:"
        << " grinder: " << grinderTaskId
        << " yt: " << ytOperationId
        << " id: " << taskId
        << " old-branch: " << oldBranchId
        << " old-commit: " << oldCommitId
        << " new-branch: " << newBranchId
        << " new-commit: " << newCommitId
        << " import-objects: " << withImportedObjects
        << " user-filter: " << userFilter
        << " already-started: " << alreadyStarted;
}

} // namespace maps::wiki::diffalert_worker
