#pragma once

#include "taskdata.h"

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/common/revision_utils.h>
#include <yandex/maps/wiki/configs/editor/config_holder.h>

#include <functional>
#include <memory>

namespace maps::wiki::diffalert_worker {

class Worker
{
public:
    Worker(
        const common::ExtendedXmlDoc& config,
        const configs::editor::ConfigHolder& editorConfig);

    enum class Status { Ok, Canceled, Failed };

    Status run(
        const TaskData& taskData,
        std::function<bool()> checkCanceled);

    TaskData loadTaskData(DBID taskId);

    pgpool3::Pool& corePool() { return revisionPoolHolder_.pool(); }

private:
    const common::ExtendedXmlDoc& config_;
    const configs::editor::ConfigHolder& editorConfig_;
    common::PoolHolder revisionPoolHolder_;
    std::unique_ptr<common::PoolHolder> viewStablePoolHolder_;
};

} // namespace maps::wiki::diffalert_worker
