#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/validator/common.h>

#include <pqxx/pqxx>
#include <memory>
#include <vector>

namespace maps::wiki::validation {

using DBID = revision::DBID;
using Uid = revision::UserID;

struct TaskData
{
    TaskData(pqxx::transaction_base& txnCore, DBID taskId);

    bool hasCheck(validator::TCheckId check) const;
    bool canSplit() const;
    void dump() const;

    std::string grinderTaskId;
    std::string ytOperationId;

    std::vector<validator::TCheckId> checks;
    std::vector<DBID> aoiIds;
    std::shared_ptr<geolib3::Polygon2> aoiGeom;
    DBID taskId = 0;
    DBID parentTaskId = 0;
    DBID commitId = 0;
    DBID branchId = 0;
    DBID regionId = 0;
    Uid uid = 0;
    double aoiBuffer = 0;
    bool isHeavy = false;
    bool onlyChangedObjects = false;
    size_t startCount = 0;
};

} // namespace maps::wiki::validation
