#pragma once

#include "taskdata.h"

#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/tasks/task_logger.h>
#include <yandex/maps/wiki/validator/validator.h>
#include <yandex/maps/wiki/validator/validator_config.h>

#include <functional>
#include <memory>

namespace maps::wiki::validation {

class Worker
{
public:
    Worker(
        const common::ExtendedXmlDoc& config,
        const validator::ValidatorConfig& validatorConfig,
        bool isHeavy);

    void prepareTaskData(TaskData& taskData);
    bool splitTasks(const TaskData& taskData);

    enum class Status { Ok, Canceled, NeedRetry, Failed };

    Status run(
        const TaskData& taskData,
        std::function<bool()> checkCanceled);

    TaskData loadTaskData(DBID taskId);

    pgpool3::Pool& corePool() { return longReadPoolHolder_.pool(); }

    void setMaxCheckThreads(size_t maxCheckThreads)
    {
        maxCheckThreads_ = maxCheckThreads;
    }

    void cleanResults(DBID taskId);

private:
    void dualInfo(const std::string& str) const;
    void dualWarn(const std::string& str) const;
    void dualError(const std::string& str) const;
    void initTaskLogger(const TaskData& taskData);
    pgpool3::Pool& validationPool();

    const common::ExtendedXmlDoc& config_;
    const validator::ValidatorConfig& validatorConfig_;
    validator::Validator validator_;
    common::PoolHolder longReadPoolHolder_;
    std::unique_ptr<common::PoolHolder> validationPoolHolder_;
    std::unique_ptr<tasks::TaskPgLogger> taskLogger_;
    size_t maxCheckThreads_ = 0;
};

} // namespace maps::wiki::validation
