const { formats } = require('@yandex-int/palmsync');

module.exports = {
    project: 'nmaps',
    retry: {
        maxRetryAfter: 1000
    },
    filePatterns: {
        yaml: /\.testpalm\.yml$/
    },
    sets: {
        yaml: {
            desktop: {
                specs: [
                    '**/*.testpalm.yml',
                ],
                envs: [{
                    PLATFORM: 'desktop'
                }],
                browsers: ['ie11', 'firefox', 'chrome-desktop']
            }
        },
    },
    validationOpts: {
        skip: ['scenarios'],
        mode: ['required-step-before-expect']
    },
    synchronizationOpts: {
        skip: [
            'geminiReportTests',
            'hermioneReportTests',
            'hermioneE2eReportTests',
            'hermioneE2eTests',
            'hermioneTests',
            'urlsByShowCounters',
            'removeTestCases'
        ],
        maxSoftErrorsThreshold: 3,
        saveAttributeValues: ['passedByAssessors','palmsync'],
        attachBugFilterLinkToTestCasePreconditions: false,
        formatter: 'withExpectationSyntax'
    },
    schemeExtension: [
        //custom names
        {
            name: 'test type',
            required: true,
            meta: true,
            format: formats.isEnum('smoke', 'acceptance', 'regress')
        },
        {
            name: 'Case Type',
            meta: true,
            format: formats.isEnum('ch')
        },
        {
            name: 'assessors',
            defaultValue: ['ready'],
            meta: true,
            format: formats.isEnum('ready', 'nsfa')
        },
        {
            name: 'nsfa reason',
            meta: true,
            format: formats.isEnum('time', 'access', 'special app', 'special accessories', 'field test', 'logs')
        },
        {
            name: 'emulator',
            defaultValue: ['suitable'],
            meta: true,
            format: formats.isEnum('suitable', 'not suitable for emulator')
        },
        {
            name: 'palmsync',
            defaultValue: ['yes'],
            meta: true,
            format: formats.isEnum('yes')
        },
        {
            name: 'uploadedToArcadia',
            defaultValue: ['yes'],
            meta: true,
            format: formats.isEnum('yes')
        },
        {
            name: 'features',
            required: true,
            mergeable: true,
            meta: true,
            format: formats.isArrayOfEnums(
                'acl',
                'activity monitor',
                'advanced mode',
                'altay',
                'assessment',
                'attrs-filters',
                'badges',
                'bans',
                'branch',
                'chats',
                'comments',
                'commits',
                'diff',
                'diffalert',
                'done tasks',
                'editor',
                'edits feed',
                'export',
                'feedback',
                'feeds',
                'filters',
                'geojson-export',
                'group edit',
                'help panel',
                'import',
                'indoor',
                'landing',
                'layers',
                'live mode',
                'locale',
                'long tasks',
                'mailing',
                'merge',
                'messages',
                'mobile',
                'moderation',
                'mrc',
                'my edits',
                'name',
                'obj history',
                'old browser',
                'onboarding',
                'panorama',
                'profile',
                'rating',
                'renderer',
                'router',
                'search',
                'shift',
                'subscriptions',
                'start',
                'tools',
                'tracker',
                'transport',
                'user tasks',
                'validation',
                'whatshere'
            )
        },
        {
            name: 'category',
            mergeable: true,
            meta: true,
            format: formats.isArrayOfEnums(
                'areal object',
                'contour object',
                'line object',
                'point object',
                'service object',
                'ad',
                'address',
                'aoi',
                'bld_complex',
                'building',
                'center',
                'cond',
                'cond_cam',
                'cond_ds',
                'entry',
                'exit',
                'fence',
                'hydro',
                'indoor',
                'junction',
                'metro',
                'mrc',
                'parking',
                'platform',
                'poi',
                'radiomap',
                'railroad',
                'rd_el',
                'region',
                'relief',
                'river',
                'roadnet',
                'route',
                'station',
                'street',
                'territory',
                'thread',
                'transport',
                'urban',
                'vegetation',
                'vehicle_restriction',
                'water transport'
            )
        },
        {
            name: 'action',
            mergeable: true,
            meta: true,
            format: formats.isArrayOfEnums(
                'attrs',
                'geom',
                'change',
                'create',
                'add',
                'alert',
                'approve',
                'block',
                'cancel',
                'copy',
                'cut',
                'delete',
                'drag',
                'error',
                'export',
                'filter',
                'geolock',
                'hotkey',
                'hover',
                'import',
                'interface',
                'link',
                'merge',
                'need info',
                'publish',
                'redirect',
                'reject',
                'reset',
                'resolution',
                'revert',
                'snap',
                'zoom'
            )
        },
        {
            name: 'roles',
            mergeable: true,
            meta: true,
            format: formats.isArrayOfEnums(
                'banned',
                'cartographer',
                'common',
                'deleted',
                'expert',
                'logout',
                'moderator',
                'novice',
                'outsource',
                'robot'
            )
        },
        {
            name: 'locale',
            meta: true,
            format: formats.isEnum('tr')
        },
        {
            name: 'for pad',
            meta: true,
            format: formats.isEnum('yes')
        },

        //disabled names
        {
            name: 'scenarioType',
            meta: false
        },
        {
            name: 'browsers',
            meta: false
        },
        {
            name: "hermioneTitle",
            meta: false,
        },
        {
            name: "palmsync_synchronization_errors",
            meta: false,
        },
        {
            name: "feature",
            meta: false,
        }
    ],
    testCaseDecorator: (testCase) => {
    },
    assertActionCostInSecs: 30
};
