#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <maps/libs/geolib/include/point.h>

#include <map>
#include <set>
#include <vector>

namespace maps::wiki::business_entrance_import_tool {

using PermalinkId = uint64_t;

struct YtOrganization
{
    revision::DBID ftId;
    geolib3::Point2 pos;
    std::vector<geolib3::Point2> entrancePos;
    std::vector<PermalinkId> locatedAt;
};

using YtOrganizations = std::vector<YtOrganization>;

struct YtData
{
    YtOrganizations orgs;
    std::set<PermalinkId> mallPermalinks;
};

struct NkPoi {
    revision::DBID ftId;
    std::string categoryId;
};

using NkData = std::map<revision::DBID, NkPoi>;

struct Entrance
{
    geolib3::Point2 pos;
    std::vector<NkPoi> pois;
};

using Entrances = std::vector<Entrance>;

} // maps::wiki::business_entrance_import_tool
