#pragma once

#include <string>

using CatGroup = std::string;
using maps::wiki::types::TUid;

struct UidGroup
{
    TUid uid{};
    CatGroup group{};
};

struct EditsStat
{
    size_t total{};
    size_t created{};
};

bool operator < (const UidGroup& lhs, const UidGroup& rhs)
{
    if (lhs.uid != rhs.uid) {
        return lhs.uid < rhs.uid;
    }
    return lhs.group < rhs.group;
}
