#!/usr/bin/python
# coding: utf-8
# Скрипт-обертка для запуска celeryd под upstart.
#
# Запускает celeryd в дочернем процессе (лидером отдельной группы процессов)
# под заданным пользователем.
# Сигналы SIGTERM, SIGHUP, SIGQUIT, SIGUSR1, SIGUSR2, SIGINT пробрасываются дочернему
# процессу.
#
# sudo плохо подходит для задачи запуска celeryd, потому что он после получения SIGTERM
# посылает SIGKILL дочернему процессу, если тот не успел завершиться в течение 3-х секунд,
# а это приводит к некорректному завершению текущих заданий.
#
import pwd
import sys
import signal
import os

PASS_SIGNALS = [signal.SIGTERM, signal.SIGHUP, signal.SIGQUIT, signal.SIGUSR1,
                signal.SIGUSR2, signal.SIGINT]
child = None


def sig_handler(signum, frame):
    if child:
        os.kill(child, signum)


def main():
    if len(sys.argv) < 3:
        print "USAGE: %s user celeryd args" % sys.argv[0]
        sys.exit(1)
    username = sys.argv[1]
    cmd = sys.argv[2:]
    user = pwd.getpwnam(username)
    if not user:
        print "User %s does not exist" % username
        sys.exit(2)
    os.setgid(user.pw_gid)
    os.setuid(user.pw_uid)

    global child
    child = os.fork()
    if not child:
        os.setsid()
        os.execv(cmd[0], cmd)

    for signum in PASS_SIGNALS:
        signal.signal(signum, sig_handler)

    while True:
        try:
            _, status = os.wait()
            sys.exit(status)
        except OSError:
            # wait for interruption by signal
            continue


if __name__ == '__main__':
    main()
