#!/bin/bash

if [ -z "$1" ]; then DIR=$PWD; else DIR=$1; fi # pwd - for development

S3_PREFIX_FILE="$DIR/envdir/WALE_S3_PREFIX"
if ! [ -r $S3_PREFIX_FILE ]; then
    echo "Can not find $S3_PREFIX_FILE. Skip."
    exit 0
fi

# WALE_S3_PREFIX:
# s3://mapsdb/wal-g/maps_db_main/9.5/

S3_BUCKET=`cut -f3 -d/ $S3_PREFIX_FILE`  # mapsdb
S3_PREFIX=`cut -f4- -d/ $S3_PREFIX_FILE` # wal-g/maps_db_main/9.5/
PGCLUSTER=`cut -f5 -d/ $S3_PREFIX_FILE`  # maps_db_main
PGVERSION=`cut -f6 -d/ $S3_PREFIX_FILE`  # 9.5

PG_DIR="/var/lib/postgresql/$PGVERSION/main"
if [ -r $PG_DIR/recovery.conf ]; then
    echo "PosgreSQL ($PGCLUSTER,$PGVERSION) is in recovery mode. Skip."
    exit 0
fi

CMD_S3TOOL="/usr/bin/envdir $DIR/envdir /usr/bin/yandex-maps-wiki-s3tool --bucket $S3_BUCKET"
TMP_FILE="/var/tmp/dbs3.$PGCLUSTER.$PGVERSION.tmp"
TMP_LIST_FILE="/var/tmp/dbs3.$PGCLUSTER.$PGVERSION.list.tmp"
YM=`date +'%Y-%m'` # 2018-12
FILTER_SENTINEL="grep sentinel"

copy_to_monthly() (
    # copy wal-g/maps_db_main/9.5/wal_005/0000000100000C87000000CE.lz4
    # to monthly-wal-g/maps_db_main/9.5/wal_005/0000000100000C87000000CE.lz4
    # $TMP_FILE will be deleted
    $CMD_S3TOOL --action copy --prefix $1 --filepath $TMP_FILE --to monthly-$1 --verbose
)


# 1. cleanup old monthly backups data
# keep 12 backups
/usr/bin/envdir $DIR/envdir /usr/bin/yandex-maps-wiki-dbs3-wal-g-monthly.sh delete retain FIND_FULL 12 --confirm
# keep 400 days
for i in {"base","wal"}; do
    $CMD_S3TOOL --action clean --incremental-clean --prefix monthly-$S3_PREFIX$i --keep 400 --limit 1000 --verbose
done


# 2. check existed monthly backup (check sentinel)
# 2018-12-XX XX:XX:XX 250562 wal-g/maps_db_main_monthly/9.5/basebackups_005/base_0000000100000C87000000DB_backup_stop_sentinel.json
$CMD_S3TOOL --action list --prefix monthly-$S3_PREFIX"base" > $TMP_LIST_FILE || exit
SENTINEL_HEAD_FULL_MONTHLY=`$FILTER_SENTINEL $TMP_LIST_FILE | egrep ^$YM- | head --lines 1`
if ! [ -z "$SENTINEL_HEAD_FULL_MONTHLY" ]; then
    echo "Already exists $SENTINEL_HEAD_FULL_MONTHLY. Skip."
    exit 0
fi


# 3. check current full backup (check sentinel without diff's)
# 2018-12-02 08:48:28 250562 wal-g/maps_db_main/9.5/basebackups_005/base_0000000100000C87000000DB_backup_stop_sentinel.json
$CMD_S3TOOL --action list --prefix $S3_PREFIX"base" > $TMP_LIST_FILE || exit
SENTINEL_HEAD_FULL=`$FILTER_SENTINEL $TMP_LIST_FILE | egrep ^$YM- | grep -v _D_ | head --lines 1`
if [ -z "$SENTINEL_HEAD_FULL" ]; then
    echo "Can not find full backup ($PGCLUSTER,$PGVERSION). Skip."
    exit 0
fi
echo "Found $SENTINEL_HEAD_FULL"


# 4. copy backup data
# wal-g/maps_db_main/9.5/basebackups_005/base_0000000100000C87000000DB_backup_stop_sentinel.json
SENTINEL_FILEPATH=`echo $SENTINEL_HEAD_FULL | rev | cut -f1 -d' ' | rev`

BACKUP_BASE_DIR=`echo $SENTINEL_FILEPATH | rev | cut -f2- -d/ | rev` # wal-g/maps_db_main/9.5/basebackups_005
SENTINEL_FILE=`echo $SENTINEL_FILEPATH | rev | cut -f1 -d/ | rev`  # base_0000000100000C87000000DB_backup_stop_sentinel.json

# wal-g/maps_db_main/9.5/basebackups_005/base_0000000100000C87000000DB
BACKUP_BASE=`echo $SENTINEL_FILE | cut -f1-2 -d'_'`

# for each wal-g/maps_db_main/9.5/basebackups_005/base_0000000100000C87000000DB/
$CMD_S3TOOL --action list --prefix $BACKUP_BASE_DIR/$BACKUP_BASE/ > $TMP_LIST_FILE || exit
for i in `cat $TMP_LIST_FILE | rev | cut -f1 -d' ' | rev`; do
    # wal-g/maps_db_main/9.5/basebackups_005/base_0000000100000C87000000DB/tar_partitions/part_001.tar.lz4
    copy_to_monthly $i || exit
done


# 5. copy wal's
# for each wal-g/maps_db_main/9.5/wal
$CMD_S3TOOL --action list --prefix $S3_PREFIX"wal" > $TMP_LIST_FILE || exit
BACKUP_MONTHLY_DATE=`echo $SENTINEL_HEAD_FULL | cut -f1 -d' '` # 2018-12-02
for i in `egrep ^$BACKUP_MONTHLY_DATE $TMP_LIST_FILE | rev | cut -f1 -d' ' | rev`; do
    copy_to_monthly $i || exit
done


# 6. copy sentinel
copy_to_monthly $SENTINEL_FILEPATH || exit

rm $TMP_LIST_FILE
echo Done
