#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/point.h>

#include <optional>
#include <string>
#include <vector>

namespace maps::wiki::easyview_walkers_photos_tool {

struct PhotoData
{
    std::string tag;
    std::string urlPhoto;
    std::string urlPermalink;
    std::optional<geolib3::Point2> coordObject;
    std::optional<geolib3::Point2> coordTaking;
    std::string permalink;
    maps::chrono::TimePoint submitTs;
};

using PhotosData = std::vector<PhotoData>;

PhotosData readPhotoDataFromYt(
    size_t limit = 0,
    bool ignoreOldPhotos = true);

} // maps::wiki::easyview_walkers_photos_tool
