#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/json/include/value.h>
#include <string>
#include <vector>

namespace maps::wiki::fbapi_social_tool {

class FbapiTaskWrapper {
public:
    explicit FbapiTaskWrapper(const json::Value& originalTask);

    std::string companyId() const;
    geolib3::Point2 position() const;
    std::string comment() const;
    std::vector<std::string> attachedPhotos() const;
    std::vector<geolib3::Point2> entrances() const;

private:
    const json::Value& getValue(const std::vector<std::string>& path) const;
    const json::Value& getValue(const std::string& path) const;

    const json::Value& originalTask_;
};

} // namespace maps::wiki::fbapi_social_tool
