#include "worker.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

int main(int argc, char** argv) try
{
    maps::cmdline::Parser argsParser;
    auto socialBackofficeUrl = argsParser.string("social-backoffice-url").required()
        .help("Base url to social-backoffice. Example: http://core-nmaps-social-backoffice.maps.yandex.net/");
    auto avatarsUrl = argsParser.string("avatars-url").required()
        .help("Base url to avatars service. Example: https://avatars.mds.yandex.net/");
    auto fbapiConn = argsParser.string("fbapi-conn").required()
        .help("Connection string to fbapi database");
    auto fbapiIdsFile = argsParser.file("fbapi-ids-file").required()
        .help("File with fbapi ids");
    auto externalIdPrefix = argsParser.string("external-id-prefix")
        .defaultValue("experiment-sprav-feed-from-fbapi")
        .help("Prefix to construct external reference id <prefix>:<fbapi-id>");

    argsParser.parse(argc, argv);

    maps::wiki::fbapi_social_tool::Worker worker(
        socialBackofficeUrl, avatarsUrl, externalIdPrefix, fbapiConn);
    worker.run(fbapiIdsFile);
    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    FATAL() << "Exception caught: " << e;
    return EXIT_FAILURE;
} catch (const std::exception& ex) {
    FATAL() << "Exception caught: " << ex.what();
    return EXIT_FAILURE;
} catch (...) {
    FATAL() << "Unknown exception caught";
    return EXIT_FAILURE;
}
