#pragma once

#include <maps/libs/http/include/http.h>
#include <maps/libs/json/include/value.h>
#include <pqxx/pqxx>

namespace maps::wiki::fbapi_social_tool {

class Worker
{
public:
    Worker(
        const std::string& socialBackofficeUrl,
        const std::string& avatarsUrl,
        std::string externalIdPrefix,
        const std::string& fbapiConnStr);

    void run(const std::string& idsFile) const;

private:
    void process(const std::string& id) const;
    std::string makeHypothesis(const json::Value& originalTask) const;
    std::string makeAvatarsUrl(const std::string& key) const;

    void submit(const std::string& id, const std::string& body) const;

    const std::string socialBackofficeUrl_;
    const std::string avatarsUrl_;
    const std::string externalIdPrefix_;
    mutable http::Client httpClient_;
    mutable pqxx::connection fbapiConn_;
};

} // namespace maps::wiki::fbapi_social_tool
